##############################################################
# R-tykalu pisteiden yhdistmiseksi paikkatietoaineistoihin #
#  Arto Viinikka, SYKE                                      #
##############################################################

# Malli yhdist arvopuun pisteet niit vastaaviin paikkatietoaineistoihin ja tuottaa Jrvenpn
# viherrakenteen arvoja kuvaavan kartan spatiaalista monitavoitearviointia hydynten. 
# Mallin toimimiselle on seuraavat oletukset. 
  # Aineistot on muutettu rasterimuotoon ja ne kattavat tsmlleen saman tutkimusalueen
	# Pikseliarvot ovat muotoa [0,1] tai jatkuvia vlill [0-1] ja niill on sama solukoko
	# Rasterit sijaitsevat kaikki samassa kansiossa
	# Rastereita vastaavat pisteet on koottu erilliseen taulukkoon (.csv), ja aineistojen nimet vastaavat tsmlleen kansiossa olevien rasterien nimi
	# Mallin tiedostopolut aineistojen lukemiseen on muutettu 

# tyhjenn Environment ja muisti. Kannattaa ajaa, jos tuntuu, ett R on jumissa.
# HUOMIO! tmn jlkeen joutuu aloittamaan alusta
rm(list = ls())
lapply(paste('package:',names(sessionInfo()$otherPkgs),sep=""),detach,character.only=TRUE,unload=TRUE)
.rs.restartR()

# Ladataan tarvittavat paketit
# Tarvitsee tehd vain kerran
install.packages("raster")
install.packages("rgdal")
install.packages("sp")
install.packages("spdep")
install.packages("foreach")

# otetaan paketit kyttn 
require(raster)
require(rgdal)
require(sp)
require(spdep)
require(foreach)


# luetaan rasterit kansiosta
raster_files <- list.files("D:/HYMY/gis/demo/input/", pattern=".tif$") # vaihda tiedostopolku kansioon, miss aineistot sijaitsevat
list_raster <- lapply(raster_files, function(fl){
  raster(paste0("D:/HYMY/gis/demo/input/", fl)) # vaihda tiedostopolku kansioon, miss aineistot sijaitsevat
})

# nimetn rasterit samoin kuin kansiossa
names(list_raster) <- (raster_files) 

# plotataan haluttu rasteri testiksi
plot(list_raster[[1]]) # [[1]] vastaa kansion ensimmist rasteria

# luetaan pistetaulukko
# pistetaulukon tulee sislt kolumnit [AineistoNimi], [Pisteet]
# lisksi taulukossa on hyv olla lyhyt aineistoKuvaus, mutta tm ei ole vlttmtnt mallin kannalta
pisteet<-read.table("D:/HYMY/gis/demo/pisteytysDEMO.csv", header = TRUE, sep =";", dec=".") # vaihda tiedostopolku kansioon
# miss pistetaulukko sijaitsee


# pisteytetn aineistoa vastaavat rasterit
foreach (i = 1:length(list_raster)) %do%{
  r1=list_raster[[i]] # valitsee listalta pisteytettvn rasterin
  id=names(list_raster)[[i]] # muodostaa uuden [id] muuttujan rasterin nimest
  p1<-pisteet[pisteet$AineistoNimi == id,] # valitsee rasteria vastaavan pistemr taulukosta

  # pisteytt rasterin kertomalla jokaisen solun taulukon pistemrll
  r2<-r1*(p1[,2])
  
  # nime rasterin ja exporttaa sen ulos
  writeRaster(r2, file.path("D:/HYMY/gis/demo/pisteytetyt/",names(list_raster)[[i]]), bylayer = F, suffix='names',
              format="GTiff", overwrite = T) 
  }


# rasterien summaaminen
# luetaan pisteytetyt rasteripinnat kansiosta
raster_files_uusi <- list.files("D:/HYMY/gis/demo/pisteytetyt/", pattern=".tif$") # vaihda tiedostopolku kansioon, miss aineistot sijaitsevat
list_raster_uusi <- lapply(raster_files_uusi, function(fl){
  raster(paste0("D:/HYMY/gis/demo/pisteytetyt/", fl)) # vaihda tiedostopolku kansioon, miss aineistot sijaitsevat
})


# summataan rasterit
rasteri_summattu<-do.call("sum",list_raster_uusi)


# normalisoidaan rasteri vlille [0,1] jakamalla pikselin maksimiarvolla
rasteri_summattu_n<-rasteri_summattu/maxValue(rasteri_summattu)

# plottaan lopullinen rasteripinta
plot(rasteri_summattu) # Pisteytyksien perusteella muodostettu loppukartta, joka kuvastaa viherrakenteen arvoja 
# ekosysteemipalveluiden nkkulmasta. Pikselin korkeampi arvo tarkoittaa viherrakenteen kannalta trkemp aluetta.

plot(rasteri_summattu_n) # Pisteytyksien perusteella muodostettu loppukartta, joka kuvastaa viherrakenteen arvoja ekosysteemipalveluiden nkkulmasta. 
# Aineisto on normalisoitu vlille [0-1]. Pikselin korkeampi arvo tarkoittaa viherrakenteen kannalta trkemp aluetta.


# exportataan lopulliset tulosaineistot
# summattu rasteri
writeRaster(rasteri_summattu,  "D:/HYMY/gis/demo/output/summarasteri.tif", bylayer = F, suffix='names',
            format="GTiff", overwrite = T) # vaihda tiedostopolku kansioon, mihin aineistot kirjoitetaan
# summattu ja normalisoitu rasteri
writeRaster(rasteri_summattu_n,  "D:/HYMY/gis/demo/output/summarasteri.tif", bylayer = F, suffix='names',
            format="GTiff", overwrite = T) # vaihda tiedostopolku kansioon, mihin aineistot kirjoitetaan

