##raster=group

install.packages("raster")
install.packages("rgdal")
install.packages("sp")
install.packages("spdep")
install.packages("foreach")

require(raster)
require(rgdal) 
require(sp)
require(spdep)
require(foreach)

raster_files <- list.files("D:/HYMY/gis/demo/input/", pattern=".tif$") 
list_raster <- lapply(raster_files, function(fl){raster(paste0("D:/HYMY/gis/demo/input/", fl))})

names(list_raster) <- (raster_files) 

pisteet<-read.table("D:/HYMY/gis/demo/pisteytysDEMO.csv", header = TRUE, sep =";", dec=".")

foreach (i = 1:length(list_raster)) %do%{
  r1=list_raster[[i]]
  id=names(list_raster)[[i]] 
  p1<-pisteet[pisteet$AineistoNimi == id,] 

  r2<-r1*(p1[,2])
  
  writeRaster(r2, file.path("D:/HYMY/gis/demo/pisteytetyt/",names(list_raster)[[i]]), bylayer = F, suffix='names',
format="GTiff", overwrite = T) 
  }

raster_files_uusi <- list.files("D:/HYMY/gis/demo/pisteytetyt/", pattern=".tif$") 
list_raster_uusi <- lapply(raster_files_uusi, function(fl){
  raster(paste0("D:/HYMY/gis/demo/pisteytetyt/", fl)) 
})

rasteri_summattu<-do.call("sum",list_raster_uusi)

rasteri_summattu_n<-rasteri_summattu/maxValue(rasteri_summattu)

writeRaster(rasteri_summattu,  "D:/HYMY/gis/demo/output/summarasteri.tif", bylayer = F, suffix='names',
format="GTiff", overwrite = T) 

writeRaster(rasteri_summattu_n,  "D:/HYMY/gis/demo/output/summarasteri_norm.tif", bylayer = F, suffix='names',
format="GTiff", overwrite = T) 
